/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
import java.util.Vector; import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class EmbeddedObjectRTNAgent extends AgentBase {

	private static final String PATH = "C:\\temp\\";
	private static final int [] TYPES = {
		RichTextItem.RTELEM_TYPE_FILEATTACHMENT,	//8
		RichTextItem.RTELEM_TYPE_OLE,				//9
		RichTextItem.RTELEM_TYPE_DOCLINK,			//5
		RichTextItem.RTELEM_TYPE_TABLE,				//1
		RichTextItem.RTELEM_TYPE_SECTION			//6
	};

	public void NotesMain() {
		Document doc = null;
		Database db = null; EmbeddedObject eo = null;
		RichTextItem rt = null; RichTextNavigator rtn = null;
		try {
			Session session = getSession();
			AgentContext agentContext = session.getAgentContext();
			db = agentContext.getCurrentDatabase();
			doc = agentContext.getDocumentContext();
			rt = (RichTextItem) doc.getFirstItem("F_richText");
			System.out.println ("RichText Item: " + rt.getName());
			System.out.println ("RichText: <<<" + rt.getText() + ">>>\n\n");
			rtn = rt.createNavigator();
			System.out.println ("RTN geladen: " + (rtn !=null));
			for (int k=0; k < TYPES.length; k++) {
				System.out.println ("\nType: " + TYPES[k]);
				System.out.println ("Object gefunden: " + rtn.findFirstElement(TYPES[k]));
				Base obj = rtn.getFirstElement(TYPES [k]);
				System.out.println ("Object geladen: " + (obj!=null));
				if (obj != null) {
					System.out.println (obj.toString());
					if (obj instanceof EmbeddedObject) {
						eo = (EmbeddedObject) obj;
						System.out.println ("Name: " + eo.getName());
						System.out.println ("Source: " + eo.getSource());
						System.out.println ("Type: " + eo.getType());
						Vector verbs = eo.getVerbs();
						if (eo != null && verbs.size() > 0) {
							for (int l = 0; l < verbs.size(); l++) {
								System.out.println ("Verb = " + (String)verbs.elementAt(l));
							}
						} else {
							System.out.println ("Keine verbs");
						}
					} 
				obj.recycle(); obj=null;
				}
			}
		} catch(Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (rt != null) {rt.recycle();}
				if (eo != null) {eo.recycle();}
				if (doc != null) {doc.recycle();}
				if (db != null) {db.recycle();}
			} catch (NotesException e1) {
				e1.printStackTrace();
			}
		}
	}
}
